
// OPOS_LinedisplayDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OPOS_Linedisplay.h"
#include "OPOS_LinedisplayDlg.h"
#include "afxdialogex.h"
#include "OposDisp.h"
CString Log_;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// COPOS_LinedisplayDlg dialog

#define SETNUMSTATUS( pStatus, pVal )	\
	str = L"";	\
	str.Format(L"%s: %d",pStatus ,pVal);	\
	m_log.InsertString(cx++, str);	\
	Log_ = Log_ + str + L"\n";

#define SETSTRSTATUS( pStatus, pStr )	\
	str = L"";	\
	str.Format(L"%s: %s",pStatus, pStr);	\
	m_log.InsertString(cx++, str);	\
	Log_ = Log_ + str + L"\n";

#define LOGLINE	\
	m_log.InsertString(cx++, L"----------------------------------------------------");

COPOS_LinedisplayDlg::COPOS_LinedisplayDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(COPOS_LinedisplayDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COPOS_LinedisplayDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LINEDISPLAY1, m_opos);
	DDX_Control(pDX, IDC_LIST1, m_log);
	DDX_Control(pDX, ID_ST_TYPE, m_st_type);
	DDX_Control(pDX, ID_MT_TYPE, m_mt_type);
}

BEGIN_MESSAGE_MAP(COPOS_LinedisplayDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDOK, &COPOS_LinedisplayDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDOK2, &COPOS_LinedisplayDlg::OnBnClickedOk2)
	ON_BN_CLICKED(IDOK3, &COPOS_LinedisplayDlg::OnBnClickedOk3)
	ON_BN_CLICKED(IDOK4, &COPOS_LinedisplayDlg::OnBnClickedOk4)
	ON_BN_CLICKED(IDOK5, &COPOS_LinedisplayDlg::OnBnClickedOk5)
	ON_BN_CLICKED(IDCANCEL, &COPOS_LinedisplayDlg::OnBnClickedCancel)
	ON_BN_CLICKED(IDOK6, &COPOS_LinedisplayDlg::OnBnClickedOk6)
	ON_BN_CLICKED(IDOK7, &COPOS_LinedisplayDlg::OnBnClickedOk7)
	ON_BN_CLICKED(IDOK8, &COPOS_LinedisplayDlg::OnBnClickedOk8)
	ON_BN_CLICKED(IDOK9, &COPOS_LinedisplayDlg::OnBnClickedOk9)
	ON_COMMAND(ID_FILE_EXIT, &COPOS_LinedisplayDlg::OnFileExit)
	ON_BN_CLICKED(IDOK10, &COPOS_LinedisplayDlg::OnBnClickedOk10)
END_MESSAGE_MAP()


// COPOS_LinedisplayDlg message handlers

BOOL COPOS_LinedisplayDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	CString str;
	long val;
	int cx =0;

	SETNUMSTATUS( L"Open",			m_opos.Open(L"CPDSO"))
	SETNUMSTATUS( L"ClaimDevice", m_opos.ClaimDevice(1000) )

	m_opos.put_DeviceEnabled(true);
	str.Format(L"put_DeviceEnabled:true");
	m_log.InsertString(cx++, str);

	SETNUMSTATUS( L"CheckHealth", m_opos.CheckHealth(1) )

	GetDlgItem(IDC_EDIT1)->SetWindowText(L"1");
	GetDlgItem(IDC_EDIT2)->SetWindowText(L"1");
	GetDlgItem(IDC_EDIT3)->SetWindowText(L"1");
	GetDlgItem(IDC_EDIT4)->SetWindowText(L"1");
	GetDlgItem(ID_TEXT)->SetWindowText(L"TestX");

	cx=0;
	m_st_type.InsertString(cx++, L"DISP_ST_UP");
	m_st_type.InsertString(cx++, L"DISP_ST_DOWN");
	m_st_type.InsertString(cx++, L"DISP_ST_LEFT");
	m_st_type.InsertString(cx++, L"DISP_ST_RIGHT");
	m_st_type.SetCurSel(0);

	cx=0;
	m_mt_type.InsertString(cx++, L"DISP_MT_NONE");
	m_mt_type.InsertString(cx++, L"DISP_MT_UP");
	m_mt_type.InsertString(cx++, L"DISP_MT_DOWN");
	m_mt_type.InsertString(cx++, L"DISP_MT_LEFT");
	m_mt_type.InsertString(cx++, L"DISP_MT_RIGHT");
	m_mt_type.InsertString(cx++, L"DISP_MT_INIT");
	m_mt_type.SetCurSel(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void COPOS_LinedisplayDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COPOS_LinedisplayDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COPOS_LinedisplayDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void COPOS_LinedisplayDlg::OnBnClickedOk()
{
	CString str;
	long val,cx=0;
	GetDlgItem(ID_TEXT)->GetWindowText(str);
	val = m_opos.DisplayText( str, DISP_DT_NORMAL);
	str.Format(L"DisplayText:%d ", val);
	m_log.InsertString(0, str);
	SETNUMSTATUS( L"get_CursorRow",			m_opos.get_CursorRow() )
	SETNUMSTATUS( L"get_CursorColumn",		m_opos.get_CursorColumn() )
}

void COPOS_LinedisplayDlg::OnBnClickedOk2()
{
	CString str;
	long val,cx=0;
	m_log.ResetContent();

	SETNUMSTATUS( L"get_CapBlink",					m_opos.get_CapBlink())
	SETNUMSTATUS( L"get_CapBrightness",				m_opos.get_CapBrightness())
	SETNUMSTATUS( L"get_CapCharacterSet",			m_opos.get_CapCharacterSet())
	SETNUMSTATUS( L"get_CapDescriptors",				m_opos.get_CapDescriptors())
	SETNUMSTATUS( L"get_CapHMarquee",					m_opos.get_CapHMarquee())
	SETNUMSTATUS( L"get_CapICharWait",				m_opos.get_CapICharWait())
	SETNUMSTATUS( L"get_CapVMarquee",					m_opos.get_CapVMarquee())
	SETNUMSTATUS( L"get_CapPowerReporting",			m_opos.get_CapPowerReporting())
	SETNUMSTATUS( L"get_CapBlinkRate",				m_opos.get_CapBlinkRate())
	SETNUMSTATUS( L"get_CapCursorType",				m_opos.get_CapCursorType())
	SETNUMSTATUS( L"get_CapCustomGlyph",				m_opos.get_CapCustomGlyph())
	SETNUMSTATUS( L"get_CapReadBack",					m_opos.get_CapReadBack())
	SETNUMSTATUS( L"get_CapReverse",					m_opos.get_CapReverse())
	SETNUMSTATUS( L"get_CursorType",					m_opos.get_CapReadBack())
	SETNUMSTATUS( L"get_CapBitmap",					m_opos.get_CapBitmap())
	SETNUMSTATUS( L"get_CapMapCharacterSet",			m_opos.get_CapMapCharacterSet())
	SETNUMSTATUS( L"get_CapScreenMode",				m_opos.get_CapScreenMode())
	SETNUMSTATUS( L"get_CapStatisticsReporting",	m_opos.get_CapStatisticsReporting())
	SETNUMSTATUS( L"get_CapUpdateStatistics",		m_opos.get_CapUpdateStatistics())
	SETNUMSTATUS( L"get_CapCompareFirmwareVersion",	m_opos.get_CapCompareFirmwareVersion())
	SETNUMSTATUS( L"get_CapUpdateFirmware",			m_opos.get_CapUpdateFirmware())

}

void COPOS_LinedisplayDlg::OnBnClickedOk3()
{
	CString str;
	long val,cx=0;
	m_log.ResetContent();

	SETNUMSTATUS( L"Open",			m_opos.Open(L"CPDSO"))	//LDN Test
	SETNUMSTATUS( L"ClaimDevice", m_opos.ClaimDevice(10) )

	m_opos.put_DeviceEnabled(true);
	str.Format(L"put_DeviceEnabled:true");
	m_log.InsertString(cx++, str);

	//SETNUMSTATUS( L"CheckHealth", m_opos.CheckHealth(OPOS_CH_INTERACTIVE) )

}

void COPOS_LinedisplayDlg::OnBnClickedOk4()
{
	CString str;
	long val,cx=0;
	m_log.ResetContent();

	m_opos.put_DeviceEnabled(false);
	str.Format(L"put_DeviceEnabled:0");
	m_log.InsertString(cx++, str);

	SETNUMSTATUS( L"ReleaseDevice", m_opos.ReleaseDevice() )
	SETNUMSTATUS( L"Close", m_opos.Close() )
	SETNUMSTATUS( L"CheckHealth", m_opos.CheckHealth(1) )
}

void COPOS_LinedisplayDlg::OnBnClickedOk5()
{
	CString str;
	long val,cx=0;
	m_log.ResetContent();

	SETSTRSTATUS( L"get_ServiceObjectDescription",	m_opos.get_ServiceObjectDescription() )
	SETSTRSTATUS( L"get_DeviceDescriptors",			m_opos.get_DeviceDescriptors() )
	SETSTRSTATUS( L"get_DeviceName",					m_opos.get_DeviceName() )
	SETSTRSTATUS( L"get_CheckHealthText",			m_opos.get_CheckHealthText() )
	SETSTRSTATUS( L"get_DeviceDescription",			m_opos.get_DeviceDescription() )
	SETSTRSTATUS( L"get_CharacterSetList",			m_opos.get_CharacterSetList() )
	SETSTRSTATUS( L"get_CustomGlyphList",			m_opos.get_CustomGlyphList() )
	LOGLINE
	SETNUMSTATUS( L"get_Claimed",						m_opos.get_Claimed() )
	SETNUMSTATUS( L"get_OpenResult",					m_opos.get_OpenResult() )
	SETNUMSTATUS( L"get_DeviceEnabled",				m_opos.get_DeviceEnabled() )
	SETNUMSTATUS( L"get_FreezeEvents",				m_opos.get_FreezeEvents() )
	SETNUMSTATUS( L"get_ResultCode",					m_opos.get_ResultCode() )
	SETNUMSTATUS( L"get_State",						m_opos.get_State() )
	LOGLINE
	SETNUMSTATUS( L"get_ControlObjectVersion",		m_opos.get_ControlObjectVersion() )
	SETNUMSTATUS( L"get_ServiceObjectVersion",		m_opos.get_ServiceObjectVersion() )
	LOGLINE
	SETNUMSTATUS( L"get_CharacterSet",				m_opos.get_CharacterSet() )
	SETNUMSTATUS( L"get_Columns",						m_opos.get_Columns() )
	SETNUMSTATUS( L"get_CurrentWindow",				m_opos.get_CurrentWindow() )
	SETNUMSTATUS( L"get_CursorColumn",				m_opos.get_CursorColumn() )
	SETNUMSTATUS( L"get_CursorRow",					m_opos.get_CursorRow() )
	SETNUMSTATUS( L"get_CursorUpdate",				m_opos.get_CursorUpdate() )
	SETNUMSTATUS( L"get_DeviceBrightness",			m_opos.get_DeviceBrightness() )
	SETNUMSTATUS( L"get_DeviceColumns",				m_opos.get_DeviceColumns() )
	SETNUMSTATUS( L"get_DeviceRows",					m_opos.get_DeviceRows() )
	SETNUMSTATUS( L"get_DeviceWindows",				m_opos.get_DeviceWindows() )
	SETNUMSTATUS( L"get_InterCharacterWait",			m_opos.get_InterCharacterWait() )
	SETNUMSTATUS( L"get_MarqueeFormat",				m_opos.get_MarqueeFormat() )
	SETNUMSTATUS( L"get_MarqueeRepeatWait",			m_opos.get_MarqueeRepeatWait() )
	SETNUMSTATUS( L"get_MarqueeType",					m_opos.get_MarqueeType() )
	SETNUMSTATUS( L"get_MarqueeUnitWait",			m_opos.get_MarqueeUnitWait() )
	SETNUMSTATUS( L"get_Rows",							m_opos.get_Rows() )
	LOGLINE
	SETNUMSTATUS( L"ClearDescriptors",				m_opos.ClearDescriptors() )
	SETNUMSTATUS( L"get_BinaryConversion",			m_opos.get_BinaryConversion() )
	SETNUMSTATUS( L"get_PowerNotify",					m_opos.get_PowerNotify() )
	SETNUMSTATUS( L"get_PowerState",					m_opos.get_PowerState() )
	SETNUMSTATUS( L"get_BlinkRate",					m_opos.get_BlinkRate() )
	LOGLINE
	SETNUMSTATUS( L"get_GlyphHeight",					m_opos.get_GlyphHeight() )
	SETNUMSTATUS( L"get_GlyphWidth",					m_opos.get_GlyphWidth() )
	SETNUMSTATUS( L"get_MapCharacterSet",			m_opos.get_MapCharacterSet() )
	SETNUMSTATUS( L"get_MaximumX",					m_opos.get_MaximumX() )
	SETNUMSTATUS( L"get_MaximumY",					m_opos.get_MaximumY() )
	SETNUMSTATUS( L"get_ScreenMode",					m_opos.get_ScreenMode() )
	SETNUMSTATUS( L"get_ScreenModeList",				m_opos.get_ScreenModeList() )
	LOGLINE
	SETNUMSTATUS( L"get_PowerNotify",					m_opos.get_PowerNotify() )
	SETNUMSTATUS( L"get_ResultCodeExtended",			m_opos.get_ResultCodeExtended() )
	SETNUMSTATUS( L"get_State",						m_opos.get_State() )
	SETNUMSTATUS( L"get_BinaryConversion",			m_opos.get_BinaryConversion() )
	SETNUMSTATUS( L"get_CapPowerReporting",			m_opos.get_CapPowerReporting() )

}


void COPOS_LinedisplayDlg::OnBnClickedCancel()
{
	FILE *fp;
	fp = fopen( "log.txt", "wb");
	fwrite(Log_.GetBuffer(0), 1, Log_.GetLength()*2 ,fp);
	fclose(fp);
	Sleep(100);
	CDialogEx::OnCancel();
}


void COPOS_LinedisplayDlg::OnBnClickedOk6()
{
	CString str;
	long val,cx=0;
	SETNUMSTATUS( L"ClearText", m_opos.ClearText() )
	//m_opos.put_CursorType(DISP_CT_UNDERLINE);
}

void COPOS_LinedisplayDlg::OnBnClickedOk7()
{
	CString str;
	long val,cx=0;
	//SETNUMSTATUS( L"get_ResultCode",	m_opos.get_ResultCode() )
	GetDlgItem(IDC_EDIT4)->GetWindowText(str);
	val = _tstoi(str);
	SETNUMSTATUS( L"ScrollText",	m_opos.ScrollText(m_st_type.GetCurSel()+1, val) )
}


void COPOS_LinedisplayDlg::OnBnClickedOk8()
{
	CString str;
	long val,cx=0;
	GetDlgItem(IDC_EDIT3)->GetWindowText(str);
	val = _tstoi(str);
	m_opos.put_DeviceBrightness(val);
	str.Format(L"Set Brightness:%d", val);
	m_log.InsertString(cx, str);
}



void COPOS_LinedisplayDlg::OnBnClickedOk9()
{
	CString str,tmp;
	long val,cx=0, col_=1, row_=1;
	GetDlgItem(IDC_EDIT1)->GetWindowText(str);
	row_ = _tstoi(str);
	GetDlgItem(IDC_EDIT2)->GetWindowText(str);
	col_ = _tstoi(str);
	GetDlgItem(ID_TEXT)->GetWindowText(tmp);

	//SETNUMSTATUS( L"get_ResultCode",	m_opos.get_ResultCode() )
	SETNUMSTATUS( L"DisplayTextAt",	m_opos.DisplayTextAt( row_, col_, tmp, DISP_DT_NORMAL) )
	SETNUMSTATUS( L"get_CursorRow",			m_opos.get_CursorRow() )
	SETNUMSTATUS( L"get_CursorColumn",		m_opos.get_CursorColumn() )

}


void COPOS_LinedisplayDlg::OnFileExit()
{
	exit(1);
}


void COPOS_LinedisplayDlg::OnBnClickedOk10()
{
	CString str;
	long val,cx=0;
	//SETNUMSTATUS( L"get_ResultCode",	m_opos.get_ResultCode() )

	m_opos.put_MarqueeType(m_mt_type.GetCurSel());
	
	str.Format(L"Set Marquee Type:%d", m_mt_type.GetCurSel());
	m_log.InsertString(cx, str);

	SETNUMSTATUS( L"get_MarqueeType",		m_opos.get_MarqueeType() )
}